/*
 * Decompiled with CFR 0.152.
 */
package com.xiangcao.xiangcaomengjia.block;

import com.xiangcao.xiangcaomengjia.SDMEconomyHelper;
import com.xiangcao.xiangcaomengjia.XiangcaomengjiaMod;
import com.xiangcao.xiangcaomengjia.block.SellingBinTier;
import com.xiangcao.xiangcaomengjia.block.XiangcaoSellingBinMenu;
import com.xiangcao.xiangcaomengjia.config.PriceVariationData;
import com.xiangcao.xiangcaomengjia.config.SellingBinConfig;
import com.xiangcao.xiangcaomengjia.config.XiangcaoTierConfig;
import com.xiangcao.xiangcaomengjia.network.XiangcaoNet;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.Nullable;

public class XiangcaoSellingBinBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private NonNullList<ItemStack> items;
    private UUID placerUUID;
    private int tickCounter;
    private final SellingBinTier tier;
    private final Map<Direction, LazyOptional<IItemHandler>> itemHandlers = new HashMap<Direction, LazyOptional<IItemHandler>>();

    public XiangcaoSellingBinBlockEntity(BlockPos pos, BlockState state, SellingBinTier tier) {
        super(XiangcaomengjiaMod.getBlockEntityType(tier), pos, state);
        this.tier = tier;
        this.items = NonNullList.m_122780_((int)54, (Object)ItemStack.f_41583_);
        for (Direction d : Direction.values()) {
            this.itemHandlers.put(d, (LazyOptional<IItemHandler>)LazyOptional.of(() -> new SidedInvWrapper((WorldlyContainer)this, d)));
        }
        this.itemHandlers.put(null, (LazyOptional<IItemHandler>)LazyOptional.of(() -> new SidedInvWrapper((WorldlyContainer)this, null)));
    }

    public void setPlacer(Player player) {
        UUID uuid;
        if (player != null && (uuid = player.m_20148_()) != null) {
            this.placerUUID = uuid;
            this.m_6596_();
        }
    }

    public UUID getPlacerUUID() {
        return this.placerUUID;
    }

    public int getRemainingTicks() {
        return Math.max(0, XiangcaoTierConfig.getUpdateDelayTicks(this.tier) - this.tickCounter);
    }

    public int getUpdateDelayTicks() {
        return XiangcaoTierConfig.getUpdateDelayTicks(this.tier);
    }

    private boolean isOwnerOnline() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_ || this.placerUUID == null) {
            return false;
        }
        return this.f_58857_.m_46003_(this.placerUUID) != null;
    }

    public void tick() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        int delay = XiangcaoTierConfig.getUpdateDelayTicks(this.tier);
        ++this.tickCounter;
        if (this.tickCounter < delay) {
            return;
        }
        this.tickCounter = 0;
        if (!this.isOwnerOnline()) {
            return;
        }
        try {
            this.doSell();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void doSell() {
        SellingBinConfig config = SellingBinConfig.getInstance();
        boolean changed = false;
        int processedCount = 0;
        int maxProcess = XiangcaoTierConfig.getMaxProcessPerTick(this.tier);
        for (int i = 0; i < this.items.size() && processedCount < maxProcess; ++i) {
            Player placer;
            long baseTotal;
            int remainingCapacity;
            int availableCount;
            int maxTradeCount;
            SellingBinConfig.TradeRule rule;
            ItemStack stack = (ItemStack)this.items.get(i);
            if (stack.m_41619_() || (rule = config.findTrade(stack)) == null || (maxTradeCount = Math.min((availableCount = stack.m_41613_()) / rule.inputCount, (remainingCapacity = maxProcess - processedCount) / rule.inputCount)) <= 0) continue;
            int consumed = rule.inputCount * maxTradeCount;
            long totalSDM = baseTotal = rule.sdmValue * (long)maxTradeCount;
            Level level = this.f_58857_;
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                PriceVariationData data = PriceVariationData.get(sl);
                totalSDM = data.getEffectivePriceForSell(baseTotal, rule.inputItem, consumed, sl);
                data.addSoldCount(rule.inputItem, consumed, sl.m_46467_());
            }
            stack.m_41774_(consumed);
            processedCount += consumed;
            if (stack.m_41619_()) {
                this.items.set(i, (Object)ItemStack.f_41583_);
            }
            if (this.placerUUID != null && this.f_58857_ != null && !this.f_58857_.f_46443_ && (placer = this.f_58857_.m_46003_(this.placerUUID)) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)placer;
                SDMEconomyHelper.addBalance((Player)serverPlayer, totalSDM);
            }
            changed = true;
        }
        if (changed) {
            this.m_6596_();
            Level level = this.f_58857_;
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                XiangcaoNet.broadcastPriceMultiplier(sl);
            }
        }
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)("block.xiangcaomengjia." + this.tier.name + "_selling_bin"));
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory playerInventory) {
        return new XiangcaoSellingBinMenu(id, playerInventory, this);
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        return this.items.stream().allMatch(ItemStack::m_41619_);
    }

    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        return ContainerHelper.m_18969_(this.items, (int)slot, (int)amount);
    }

    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18966_(this.items, (int)slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.items.set(slot, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_ == null || this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        this.items.clear();
    }

    public int[] m_7071_(Direction side) {
        int[] slots = new int[this.items.size()];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = i;
        }
        return slots;
    }

    public boolean m_7155_(int slot, ItemStack stack, @Nullable Direction direction) {
        return true;
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction direction) {
        return false;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        if (this.placerUUID != null) {
            tag.m_128362_("PlacerUUID", this.placerUUID);
        }
    }

    public void m_142466_(CompoundTag tag) {
        UUID loaded;
        super.m_142466_(tag);
        if (this.items == null) {
            this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        }
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        if (tag.m_128403_("PlacerUUID") && (loaded = tag.m_128342_("PlacerUUID")) != null && !loaded.equals(new UUID(0L, 0L))) {
            this.placerUUID = loaded;
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
        if (!this.f_58859_ && capability == ForgeCapabilities.ITEM_HANDLER) {
            LazyOptional<IItemHandler> h = this.itemHandlers.get(side);
            if (h != null) {
                return h.cast();
            }
            h = this.itemHandlers.get(null);
            if (h != null) {
                return h.cast();
            }
        }
        return super.getCapability(capability, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlers.values().forEach(LazyOptional::invalidate);
        this.itemHandlers.clear();
    }
}

